/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.dialog;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class VWLoggingDialog
extends JDialog
implements ActionListener {
    private JButton m_clearButton = null;
    private JButton m_closeButton = null;
    private JTextArea m_messageTextArea = null;
    private int m_nWidth = 0;
    private int m_nHeight = 0;

    public VWLoggingDialog() {
        this.init();
    }

    public VWLoggingDialog(int nWidth, int nHeight) {
        this.m_nWidth = nWidth;
        this.m_nHeight = nHeight;
        this.init();
    }

    public void print(String message) {
        if (this.m_messageTextArea != null) {
            this.m_messageTextArea.append(message);
        }
        if (!this.isVisible()) {
            this.setVisible(true);
        }
    }

    public void println(String message) {
        this.print("\n" + message);
    }

    public void actionPerformed(ActionEvent event) {
        Object objSource = event.getSource();
        if (objSource == this.m_clearButton && this.m_messageTextArea != null) {
            this.m_messageTextArea.setText("");
        }
        if (objSource == this.m_closeButton) {
            this.setVisible(false);
        }
    }

    private void init() {
        try {
            this.setVisible(false);
            if (this.m_nWidth <= 0 || this.m_nHeight <= 0) {
                this.setSize(new Dimension(640, 480));
            } else {
                this.setSize(this.m_nWidth, this.m_nHeight);
            }
            this.getContentPane().setLayout(new BorderLayout(10, 10));
            this.m_messageTextArea = new JTextArea();
            this.m_messageTextArea.setLineWrap(true);
            this.m_messageTextArea.setWrapStyleWord(true);
            this.m_messageTextArea.setEditable(false);
            this.m_messageTextArea.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.getContentPane().add((Component)new JScrollPane(this.m_messageTextArea), "Center");
            this.getContentPane().add((Component)this.createButtonPanel(), "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = null;
        try {
            buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout());
            this.m_clearButton = new JButton(VWResource.s_clear);
            this.m_clearButton.addActionListener(this);
            buttonPanel.add(this.m_clearButton);
            this.m_closeButton = new JButton(VWResource.s_close);
            this.m_closeButton.addActionListener(this);
            buttonPanel.add(this.m_closeButton);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return buttonPanel;
    }
}

